CREATE PROCEDURE dbo.CPUJ_Eventos_Cliente_Login @pJson VARCHAR(8000)
AS 
SET NOCOUNT ON

	/***************************************************************************************************

	Procedimiento:      CPUJ_Eventos_Cliente_Login
	Fecha de Creacion:  2024-06-27
	Creado por:         Adriana Laverde
	Descripcion:        Stored creado para validar y sincronizar socios que si tienen acceso a la venta de localidades en alta demanda 
	Llamado por:        kiosk/admin/venta.php
	Tablas afectadas:   
	Usado en:           Panel de Sincronizacion de localidades
	Parametro(s):       FlagUsarTrans, ModoDebug, Id_Lista_Evento, Id_Cliente
	Forma de uso:       EXEC CPUJ_Eventos_Cliente_Login '{"FlagUsarTrans":"0","ModoDebug":"0","Id_Lista_Evento":"1","Id_Cliente":"1"}'
	Notas adicionales:  

	****************************************************************************************************

	SUMARIO DE CAMBIOS
	FECHA(yyyy-mm-dd)    Autor              Comentarios
	------------------- ------------------- ------------------------------------------------------------

              
	***************************************************************************************************/

/*Variables recibidas por parámetro a traves del JSON*/
DECLARE @pFlagUsarTrans			TINYINT
DECLARE @pModoDebug				TINYINT
DECLARE @pId_Lista_Evento		INT
DECLARE @pId_Cliente			INT

SET @pFlagUsarTrans				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Lista_Evento			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Lista_Evento')), 0)
SET @pId_Cliente				= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Cliente')), 0)
/*FIN Variables recibidas por parámetro a traves del JSON*/

/*Variables Locales*/
DECLARE @Id_Cliente		INT
DECLARE @Id_Cliente_Ref	INT
DECLARE @Doc_Nro		BIGINT
DECLARE	@Email			NVARCHAR(MAX)
DECLARE @Clave			VARCHAR(30)
DECLARE @Ult_Cuota_Paga DATETIME
DECLARE @Cant_Entradas	SMALLINT
DECLARE @Razon_Social	VARCHAR(100)
DECLARE @Id_Tipo_Cli	SMALLINT	
DECLARE @Json			NVARCHAR(MAX)
DECLARE @Resultado		SMALLINT
DECLARE @SqlStr			NVARCHAR(MAX)
/*Fin Variables Locales*/

BEGIN TRY
	IF @pFlagUsarTrans <> 0 
	BEGIN
		BEGIN TRAN
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPUJ_Eventos_Cliente_Login'
		PRINT 'Parametros: '+ @pJson  
	END
	
	
	--IMPLEMENTAR!

	/*====================================================================================================================================================*/

	IF @pFlagUsarTrans <> 0 COMMIT
	
	/*====================================================================================================================================================*/

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPUJ_Eventos_Cliente_Login'
	END
	
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	IF @pFlagUsarTrans <> 0  ROLLBACK

	RETURN 9999
END CATCH

RETURN 0 
